<?php

namespace App\Models;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class AiTemplate extends Model
{
    use Filterable;

    protected $guarded = [];

    protected static function booted()
    {

        static::creating(function (Model $model) {
            $model->uid = Str::uuid();
        });

    }

    public function platform()
    {
        return $this->belongsTo(Platform::class);
    }
}
