<?php

return [
    // App Settings
    'site_name' => 'Postuno',
    'phone' => '',
    'phone_code' => '',
    'email' => '',
    'country' => '',
    'address' => '',
    'time_zone' => 'UTC',
    'date_format' => 'Y-m-d',
    'data_per_page' => '15',
    'preloader_enabled' => '1',
    'preloader_show_on_home' => '1',
    'preloader_show_on_first_login' => '1',
    'preloader_duration' => '3000',
    'default_language' => 'en',
    
    // Theme Settings
    'primary_color' => '#667eea',
    'secondary_color' => '#764ba2',
    'primary_color_text' => '#ffffff',
    'secondary_color_text' => '#ffffff',
    'body_text_primary' => '#1a202c',
    'body_text_secondary' => '#718096',
    
    // Email Settings
    'smtp_host' => '',
    'smtp_port' => '587',
    'smtp_username' => '',
    'smtp_password' => '',
    'smtp_encryption' => 'tls',
    'mail_from_address' => '',
    'mail_from_name' => '',
    'email_notifications' => '1',
    'welcome_email' => '1',
    'password_reset_email' => '1',
    'security_alerts' => '1',
    'mail_password_reset' => '1',
    'mail_account_verification' => '1',
    'mail_notifications' => '1',
    'mail_test_mode' => '0',
    
    // Storage Settings
    'max_file_size' => '10',
    'allowed_file_types' => 'jpg,jpeg,png,gif,mp4,m4v,mov,avi,webm,mkv,3gp,pdf,doc,docx',
    'image_quality' => '80',
    'storage_driver' => 'local',
    'aws_access_key_id' => '',
    'aws_secret_access_key' => '',
    'aws_default_region' => 'us-east-1',
    'aws_bucket' => '',
    'auto_resize_images' => '1',
    'generate_thumbnails' => '1',
    'thumbnail_width' => '300',
    'thumbnail_height' => '300',
    'cache_driver' => 'file',
    'cache_ttl' => '60',
    
    // Security Settings
    'two_factor_auth' => '0',
    'session_timeout' => '30',
    'max_login_attempts' => '5',
    'lockout_duration' => '15',
    'security_notifications' => '1',
    'password_min_length' => '6',
    'password_require_uppercase' => '0',
    'password_require_numbers' => '0',
    'password_require_special' => '0',
    'privacy_mode' => '0',
    'data_retention_days' => '365',
    'gdpr_compliance' => '0',
    'data_export_enabled' => '1',
    'account_deletion_enabled' => '1',
    'audit_logs_enabled' => '0',
];

