<?php

use App\Enums\PostStatus;
use App\Enums\PostType;
use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('social_posts', function (Blueprint $table) {
            $table->id();
            $table->string('uid', 100)->index()->nullable();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();

            $table->foreignId('account_id')->constrained('social_accounts')->cascadeOnDelete();
            $table->foreignId('platform_id')->constrained('platforms')->cascadeOnDelete();
            $table->foreignId('campaign_id')->nullable()->constrained('campaigns')->cascadeOnDelete();

            $table->longText('content')->nullable();
            $table->longText('link')->nullable();

            $table->boolean('is_scheduled')->default(false)->index();
            $table->timestamp('schedule_time')->nullable();
            $table->mediumInteger("repeat_every")->default(0)->comment('In minutes');
            $table->timestamp('repeat_schedule_end_date')->nullable();
            $table->boolean('is_draft')->default(false)->index();

            $table->unsignedTinyInteger('post_type')->default(PostType::FEED->value)
                ->comment('Feed :0,Reels : 1,Story :2,Shorts :3');

            $table->unsignedTinyInteger('status')->default(PostStatus::PENDING->value)
                ->comment('Pending : 0, Success: 1,Failed :2,Schedule :3')->index();
            $table->longText('platform_response')->nullable();

            $table->timestamp('posted_at')->nullable();
            $table->string('platform_post_id')->nullable();
            $table->string('post_url')->nullable();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('social_posts');
        Schema::enableForeignKeyConstraints();

    }
};
