<?php

use App\Enums\PostStatus;
use App\Enums\PostType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('campaign_posts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('campaign_id')->constrained('campaigns')->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();

            $table->foreignId('account_id')->constrained('social_accounts')->cascadeOnDelete();
            $table->foreignId('platform_id')->constrained('platforms')->cascadeOnDelete();
            $table->longText('content')->nullable();
            $table->longText('link')->nullable();
            $table->boolean('is_scheduled')->default(false)->index();
            $table->timestamp('schedule_time')->nullable();
            $table->mediumInteger('repeat_every')->default(0)->comment('In minutes');
            $table->timestamp('repeat_end_date')->nullable();
            $table->boolean('is_draft')->default(false)->index();
            $table->unsignedTinyInteger('post_type')->default(PostType::FEED->value)
                ->comment('Feed : 0,Reels "1 ,Story :2,Shorts :3');
            $table->unsignedTinyInteger('status')->default(PostStatus::PENDING->value)
                ->comment('Pending :0,Success :1,Failed :2,Scheduled :3')->index();
            $table->timestamp('posted_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('campaign_posts');
        Schema::enableForeignKeyConstraints();

    }
};
