"use client"

import { cn } from "@/Lib/utils"

export default function AiConfigurationTabs({ activeTab, onTabChange }) {
  const tabs = [
    { id: "text-module", label: "Text Module" },
    { id: "image-module", label: "Image Module" },
    { id: "video-module", label: "Video Module" },
  ]

  return (
    <div className="px-6 pt-6 pb-4">
      <div className="flex space-x-8 border-b border-gray-200">
        {tabs.map((tab) => (
          <button
            key={tab.id}
            className={cn(
              "pb-3 text-sm font-medium transition-colors relative",
              activeTab === tab.id ? "text-primary border-b-2 border-primary" : "text-gray-500 hover:text-gray-700",
            )}
            onClick={() => onTabChange(tab.id)}
          >
            {tab.label}
          </button>
        ))}
      </div>
    </div>
  )
}
