import { AreaChart, Area, XAxis, YAxis, CartesianGrid, LabelList } from "recharts"
import { ChartContainer, ChartTooltip } from "../UI/Chart"

const CustomLabel = ({ x, y, value, fill }) => {
  return (
    <g>
      <rect x={x - 15} y={y - 12} width={30} height={16} fill={fill} rx={2} ry={2} />
      <text x={x} y={y - 2} textAnchor="middle" className="fill-white text-xs font-medium">
        {value}
      </text>
    </g>
  )
}

const CustomTooltip = ({ active, payload, label }) => {
  if (active && payload && payload.length) {
    return (
      <div className="bg-white border border-gray-200 rounded-lg shadow-lg p-3 min-w-[140px]">
        <p className="text-sm font-medium text-gray-900 mb-2">{label} 2025</p>
        {payload.map((entry, index) => (
          <div key={index} className="flex items-center gap-2 mb-1">
            <div className="w-2 h-2 rounded-full" style={{ backgroundColor: entry.color }}></div>
            <span className="text-sm text-gray-600">
              {entry.name}: {entry.value.toLocaleString()}
            </span>
          </div>
        ))}
      </div>
    )
  }
  return null
}

const EngagementChart = ({ data }) => {
  const engagementData = data?.dailyEngagement || []

  const chartConfig = {
    likes: {
      label: "Likes",
      color: "var(--primary-color)",
    },
    comments: {
      label: "Comments",
      color: "#ef4444",
    },
    shares: {
      label: "Share",
      color: "#eab308",
    },
  }

  return (
    <div className="bg-white dark:bg-zinc-900 h-[32rem] rounded-lg border border-gray-200 dark:border-zinc-800 p-6">
      <div className="flex items-center justify-between flex-wrap gap-4 mb-6">
        <h3 className="text-lg font-semibold text-gray-900 dark:text-white">Engagement Analytics</h3>

        <div className="flex items-center gap-4">
          <div className="flex items-center gap-1">
            <div className="w-2 h-2 rounded-full" style={{ backgroundColor: 'var(--primary-color)' }}></div>
            <span className="text-sm text-gray-600 dark:text-gray-400">Likes</span>
          </div>
          <div className="flex items-center gap-1">
            <div className="w-2 h-2 rounded-full bg-red-500"></div>
            <span className="text-sm text-gray-600 dark:text-gray-400">Comments</span>
          </div>
          <div className="flex items-center gap-1">
            <div className="w-2 h-2 rounded-full bg-yellow-500"></div>
            <span className="text-sm text-gray-600 dark:text-gray-400">Share</span>
          </div>
        </div>
      </div>

      <ChartContainer config={chartConfig} className="lg:h-[400px] h-[300px] w-full">
        <AreaChart data={engagementData} margin={{ top: 20, right: 30, left: 20, bottom: 5 }}>
          <CartesianGrid strokeDasharray="3 3" className="stroke-gray-200 dark:stroke-zinc-700" />
          <XAxis
            dataKey="month"
            className="text-xs text-gray-600 dark:text-gray-400"
            axisLine={false}
            tickLine={false}
          />
          <YAxis
            className="text-xs text-gray-600 dark:text-gray-400"
            axisLine={false}
            tickLine={false}
            domain={[0, 'auto']}
          />
          <ChartTooltip content={<CustomTooltip />} />

          <Area
            type="monotone"
            dataKey="likes"
            stroke="var(--color-likes)"
            fill="var(--color-likes)"
            fillOpacity={0.3}
            strokeWidth={2}
          >
            <LabelList
              dataKey="likes"
              position="top"
              content={(props) => <CustomLabel {...props} fill="var(--color-likes)" />}
            />
          </Area>
          <Area
            type="monotone"
            dataKey="comments"
            stroke="var(--color-comments)"
            fill="var(--color-comments)"
            fillOpacity={0.3}
            strokeWidth={2}
          >
            <LabelList
              dataKey="comments"
              position="top"
              content={(props) => <CustomLabel {...props} fill="var(--color-comments)" />}
            />
          </Area>
          <Area
            type="monotone"
            dataKey="shares"
            stroke="var(--color-shares)"
            fill="var(--color-shares)"
            fillOpacity={0.3}
            strokeWidth={2}
          >
            <LabelList
              dataKey="shares"
              position="top"
              content={(props) => <CustomLabel {...props} fill="var(--color-shares)" />}
            />
          </Area>
        </AreaChart>
      </ChartContainer>
    </div>
  )
}

export default EngagementChart
