"use client"

import { Button } from "@/Components/UI/Button"
import { Input } from "@/Components/UI/Input"
import { RSelect } from "@/Components/UI/RSelect"
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/Components/UI/Select"
import { usePage } from '@inertiajs/react';
import countries from "@/../data/countries.json";
import { toSelectOptions } from "@/Lib";
import useTranslate from "@/hooks/useTranslate";

export default function BasicSetting({ formData, onInputChange, onSubmit, isSubmitting }) {

  const { time_zone, date_format } = usePage().props;

  const countryOptions = toSelectOptions(countries, "code", "name");
  const time_zoneOptions = Object.entries(time_zone).map(([key, value]) => ({
    value: key,
    label: value,
  }));


  const t = useTranslate();


  return (
    <div className="space-y-8">
      {/* Header */}
      <div className="flex items-center justify-between mb-6">
        <div>
          <h3 className="text-lg font-semibold text-gray-900 dark:text-gray-100">{t("Application Configuration")}</h3>
          <p className="text-sm text-gray-500 dark:text-gray-400 mt-1">
            {t("Configure general application settings and preferences")}
          </p>
        </div>
        <Button
          isLoading={isSubmitting}
          onClick={onSubmit}
          className="bg-gradient-to-r from-primary to-secondary hover:from-primary/90 hover:to-secondary/90 text-white px-6 py-2.5 rounded-lg font-medium shadow-sm transition-all duration-200 flex items-center gap-2"
        >
          {!isSubmitting && (
            <svg className="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M5 13l4 4L19 7" />
            </svg>
          )}
          {isSubmitting ? t("Saving...") : t("Save Changes")}
        </Button>
      </div>

      <div className="grid lg:grid-cols-2 grid-cols-1 lg:gap-6 gap-4">
        {/* Left Column */}
        <div className="space-y-6">
          <div>
            <label className="block text-sm font-medium text-bodyTextPrimary dark:text-neutral-400 mb-2">{t("Site Name")}</label>
            <Input
              placeholder={t("Enter name")}
              value={formData.site_name}
              onChange={(e) => onInputChange("site_name", e.target.value)}
              className="bg-gray-50 border-gray-200 dark:bg-zinc-800 dark:border-none dark:text-neutral-200"
            />
          </div>



          <div>
            <label className="block text-sm font-medium text-bodyTextPrimary dark:text-gray-200 mb-2 dark:text-neutral-400">{t("Phone")}</label>
            {/* Phone Input */}
            <Input
              id="phone"
              type="tel"
              placeholder={t("Input your phone")}
              value={formData.phone}
              onChange={(e) => onInputChange("phone", e.target.value)}
              className="bg-gray-50 border-gray-200 dark:bg-zinc-800 dark:border-none dark:text-neutral-200"
            />
          </div>

          <div>
            <label className="block text-sm font-medium text-bodyTextPrimary dark:text-gray-200 mb-2 dark:text-neutral-400">{t("Country")}</label>
            <RSelect
              options={countryOptions}
              value={formData.country}
              onChange={(val) => onInputChange("country", val)}
              placeholder={t("Select country")}
            />
          </div>

          <div>
            <label className="block text-sm font-medium text-bodyTextPrimary dark:text-gray-200 mb-2 dark:text-neutral-400">{t("Time Zone")}</label>
            <RSelect
              options={time_zoneOptions}
              value={formData.time_zone}
              onChange={(val) => onInputChange("time_zone", val)}
              placeholder={t("Select time zone")}
              className="bg-gray-50 border-gray-200 dark:bg-zinc-800 dark:border-none dark:text-neutral-200"
            />

          </div>
        </div>

        {/* Right Column */}
        <div className="space-y-6">
          
          <div>
            <label className="block text-sm font-medium text-bodyTextPrimary dark:text-gray-200 mb-2 dark:text-neutral-400">{t("Email")}</label>
            <Input
              placeholder={t("Enter email")}
              type="email"
              value={formData.email}
              onChange={(e) => onInputChange("email", e.target.value)}
              className="bg-gray-50 border-gray-200 dark:bg-zinc-800 dark:border-none dark:text-neutral-200"
            />
          </div>

          <div>
            <label className="block text-sm font-medium text-bodyTextPrimary dark:text-gray-200 mb-2 dark:text-neutral-400">{t("Address")}</label>
            <Input
              placeholder={t("Enter address")}
              value={formData.address}
              onChange={(e) => onInputChange("address", e.target.value)}
              className="bg-gray-50 border-gray-200 dark:bg-zinc-800 dark:border-none dark:text-neutral-200"
            />
          </div>

          <div>
            <label className="block text-sm font-medium text-bodyTextPrimary dark:text-gray-200 mb-2 dark:text-neutral-400">{t("Date Format")}</label>
            <Select value={formData.date_format} onValueChange={(value) => onInputChange("date_format", value)}>
              <SelectTrigger className="w-full h-9 px-3 py-2 text-sm text-bodyTextSecondary bg-gray-50 border-gray-200 dark:bg-zinc-800 dark:border-none dark:text-neutral-200">
                <SelectValue placeholder={t("Choose date format")} />
              </SelectTrigger>
              <SelectContent>
                {date_format.map((f) => (
                  <SelectItem
                   key={f.format} 
                   value={f.format}
                   className = "text-bodyTextSecondary"
                   >
                    {f.label}
                  </SelectItem>
                ))}
              </SelectContent>
            </Select>
          </div>

          <div>
            <label className="block text-sm font-medium text-bodyTextPrimary dark:text-gray-200 mb-2 dark:text-neutral-400">{t("Data Per Page")}</label>
            <Input
              value={formData.data_per_page}
              onChange={(e) => onInputChange("data_per_page", e.target.value)}
              className="bg-gray-50 border-gray-200 dark:bg-zinc-800 dark:border-none dark:text-neutral-200"
            />
          </div>
        </div>
      </div>

    </div>
  )
}