"use client"

import { useState } from "react"
import { Grid3X3, List, Search } from "lucide-react"
import PostCard from "@/Components/Calendar/PostCard"
import { Input } from "@/Components/UI/Input"

const ListView = ({ posts = [], onActiveTabChange, activePostTab, onMenuAction, openMenus, onToggleMenu, t = (key) => key, pagination, onLoadMore, isLoadingMore = false, searchQuery = "", onSearch }) => {
  const [viewMode, setViewMode] = useState("grid")

  const groupedPosts = posts.reduce((groups, post) => {
    const date = new Date(post.dateGroup).toISOString().split("T")[0]

    if (!groups[date]) {
      groups[date] = []
    }
    groups[date].push(post)

    return groups
  }, {})

  const tabs = ["all", "upcoming", "past", "drafts"];





  return (
    <div className="flex-1 bg-white dark:bg-zinc-900 rounded-xl border border-gray-200 dark:border-zinc-800">
      <div className="p-3 sm:p-4 lg:p-6 border-b border-gray-200 dark:border-zinc-800">
        {/* Unified Control Bar: Search | Status Filter | View Mode */}
        <div className="flex flex-col sm:flex-row sm:items-center gap-3 sm:gap-4 mb-3 sm:mb-4">
          {/* Search Input */}
          <div className="relative flex-1 min-w-0">
            <Search className="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 w-4 h-4" />
            <Input
              type="text"
              placeholder={t("Search posts...")}
              value={searchQuery}
              onChange={onSearch}
              className="pl-10 w-full h-10 sm:h-11 bg-white dark:bg-zinc-800 border-gray-300 dark:border-zinc-600 focus:ring-primary focus:border-primary text-sm"
            />
          </div>

          {/* Right controls (Tabs + View toggle) */}
          <div className="flex w-full sm:w-auto items-center justify-between sm:justify-end gap-3 sm:gap-4">
            {/* Status Filter - keep horizontal scroll if needed */}
            <div className="overflow-x-auto shrink-0">
              <div className="inline-flex bg-white dark:bg-zinc-900 rounded-lg p-1  gap-0.5 sm:gap-1 border border-gray-200 dark:border-zinc-800 min-w-max">
                {tabs.map((tab) => (
                  <button
                    key={tab}
                    onClick={() => onActiveTabChange(tab)}
                    className={`rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm font-medium transition-colors capitalize whitespace-nowrap ${
                      activePostTab === tab
                        ? "bg-gradient-to-r from-primary to-secondary text-white shadow-sm"
                        : "text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700"
                    }`}
                  >
                    {tab}
                  </button>
                ))}
              </div>
            </div>

            {/* View Mode Toggle */}
            <div className="flex items-center shrink-0">
              <div className="flex items-center space-x-1 bg-white dark:bg-zinc-900 rounded-lg p-1 border border-gray-200 dark:border-zinc-800">
                <button
                  onClick={() => setViewMode("grid")}
                  className={`transition-all duration-200 p-1.5 sm:p-2 rounded-md ${
                    viewMode === "grid"
                      ? "bg-gradient-to-r from-primary to-secondary text-white shadow-sm"
                      : "text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white hover:bg-gray-50 dark:hover:bg-zinc-800"
                  }`}
                  aria-label="Grid view"
                >
                  <Grid3X3 className="h-3 w-3 sm:h-4 sm:w-4" />
                </button>
                <button
                  onClick={() => setViewMode("list")}
                  className={`transition-all duration-200 p-1.5 sm:p-2 rounded-md ${
                    viewMode === "list"
                      ? "bg-gradient-to-r from-primary to-secondary text-white shadow-sm"
                      : "text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white hover:bg-gray-50 dark:hover:bg-zinc-800"
                  }`}
                  aria-label="List view"
                >
                  <List className="h-3 w-3 sm:h-4 sm:w-4" />
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>


      <div className="p-3 sm:p-4 lg:p-6">
        {Object.entries(groupedPosts).map(([dateGroup, datePosts]) => (
          <div key={dateGroup} className="mb-6 sm:mb-8">
            <h3 className="text-base sm:text-lg font-semibold text-gray-900 dark:text-white mb-3 sm:mb-4">{dateGroup}</h3>

            {viewMode === "list" ? (
              <div className="space-y-4">
                {datePosts.map((post) => (
                  <PostCard
                    key={post.id}
                    post={post}
                    viewMode="list"
                    onMenuAction={onMenuAction}
                    openMenus={openMenus}
                    onToggleMenu={onToggleMenu}
                  />
                ))}
              </div>
            ) : (
              <div className="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 lg:grid-cols-2 gap-6">
                {datePosts.map((post) => (
                  <PostCard
                    key={post.id}
                    post={post}
                    viewMode="grid"
                    onMenuAction={onMenuAction}
                    openMenus={openMenus}
                    onToggleMenu={onToggleMenu}
                  />
                ))}
              </div>
            )}
          </div>
        ))}

        {/* Load More Button */}
        {pagination && pagination.has_more_pages && (
          <div className="flex justify-center mt-8">
            <button
              onClick={onLoadMore}
              disabled={isLoadingMore}
              className="px-6 py-3 bg-gradient-to-r from-primary to-secondary text-white rounded-lg hover:from-secondary hover:to-primary disabled:opacity-50 disabled:cursor-not-allowed transition-all duration-200 font-medium"
            >
              {isLoadingMore ? "Loading..." : "Load More Posts"}
            </button>
          </div>
        )}
      </div>
    </div>
  )
}

export default ListView
