"use client"

import { Modal } from "@/Components/UI/Modal"
import { Input } from "@/Components/UI/Input"
import { Label } from "@/Components/UI/Label"
import { Sparkle } from "lucide-react"
import { useState } from "react"
import { router } from "@inertiajs/react"
import { route } from "ziggy-js"
import useTranslate from "@/hooks/useTranslate"

export default function CreateWorkspaceModal({ isOpen, onClose }) {
  const [formData, setFormData] = useState({
    name: "",
    email: "",
  })
  const [isSubmitting, setIsSubmitting] = useState(false)
  const t = useTranslate()

  const handleInputChange = (e) => {
    const { name, value } = e.target
    setFormData((prev) => ({
      ...prev,
      [name]: value,
    }))
  }

  const handleCreateWorkspace = () => {
    setIsSubmitting(true)
    router.post(route('user.workspace.store'), formData, {
      onSuccess: () => {
        setFormData({ name: "", email: "" })
        onClose()
        setIsSubmitting(false)
      },
      onError: () => {
        setIsSubmitting(false)
      }
    })
  }

  const handleClose = () => {
    setFormData({ name: "", email: "" })
    onClose()
  }

  return (
    <Modal
      isOpen={isOpen}
      onClose={handleClose}
      onSubmit={handleCreateWorkspace}
      submitText={t("Create Workspace")}
      title={
        <div className="flex items-center gap-3">
          <div className="w-8 h-8 bg-gradient-to-r from-primary to-secondary rounded-lg flex items-center justify-center">
            <Sparkle className="w-4 h-4 text-white" />
          </div>
          <div>
            <h2 className="text-lg font-semibold text-gray-900 dark:text-gray-100">
              {t("Create Workspace")}
            </h2>
          </div>
        </div>
      }
      className="max-w-md"
      width="w-[26rem]"
      buttonWidth="w-full"
      isSubmitting={isSubmitting}
    >
      <div className="space-y-4">
        <p className="text-sm text-gray-500 dark:text-gray-400 text-center">
          {t("Create a new workspace to organize your projects and team collaboration")}
        </p>
      </div>

      <div className="space-y-4">
        {/* Name Input */}
        <div className="space-y-2">
          <Label className="dark:text-zinc-100" htmlFor="workspace-name">
            {t("Name")}
          </Label>
          <Input
            id="workspace-name"
            name="name"
            placeholder={t("Enter your workspace name")}
            value={formData.name}
            onChange={handleInputChange}
            className="w-full"
            required
            disabled={isSubmitting}
          />
        </div>

        {/* Email Input */}
        <div className="space-y-2">
          <Label className="dark:text-zinc-100" htmlFor="workspace-email">
            {t("Email")}
          </Label>
          <Input
            id="workspace-email"
            name="email"
            type="email"
            placeholder={t("Enter your workspace email")}
            value={formData.email}
            onChange={handleInputChange}
            className="w-full"
            required
            disabled={isSubmitting}
          />
        </div>
      </div>
    </Modal>
  )
}