import { Heart, MessageCircle, Share } from "lucide-react"

export default function TikTokPreview({ postContent = "", postType = "video", selectedMedia = [] }) {
  // Mock user data - in real app this would come from selected account
  const mockUser = {
    name: "James Clerk",
    username: "@jamesclerk",
    avatar: "/diverse-user-avatars.png",
    verified: false,
  }

  const highlightContent = (text) => {
    const urlRegex = /(https?:\/\/[^\s]+)/g
    const parts = text.split(urlRegex)

    return parts.map((part, index) => {
      if (urlRegex.test(part)) {
        return (
          <span key={index} className="text-blue-400">
            {part}
          </span>
        )
      }
      return part
    })
  }

  return (
    <div className="bg-black rounded-lg overflow-hidden aspect-[9/16] max-w-[300px] mx-auto relative">
      {selectedMedia.length > 0 && selectedMedia[0].type === "video" ? (
        <video
          src={selectedMedia[0].url}
          poster={selectedMedia[0].thumbnail}
          className="w-full h-full object-cover"
          autoPlay
          muted
          loop
          playsInline
        >
          Your browser does not support the video tag.
        </video>
      ) : selectedMedia.length > 0 && selectedMedia[0].type === "image" ? (
        <img
          src={selectedMedia[0].thumbnail || selectedMedia[0].url}
          alt={selectedMedia[0].alt || "TikTok image"}
          className="w-full h-full object-cover"
        />
      ) : (
        <div className="absolute inset-0 flex items-center justify-center text-white">
          <div className="text-center">
            <div className="w-16 h-16 bg-pink-500 rounded-full flex items-center justify-center mb-2 mx-auto">
              <div className="w-0 h-0 border-l-[8px] border-l-white border-y-[6px] border-y-transparent ml-1"></div>
            </div>
            <p className="text-sm">No video selected</p>
          </div>
        </div>
      )}

      <div className="absolute bottom-0 left-0 right-0 p-4 bg-gradient-to-t from-black/80 to-transparent">
        <div className="flex items-end gap-3">
          <div className="flex-1">
            <div className="flex items-center gap-2 mb-2">
              <img src={mockUser.avatar || "/placeholder.svg"} alt={mockUser.name} className="w-8 h-8 rounded-full" />
              <span className="text-white font-medium">{mockUser.username}</span>
            </div>
            <p className="text-white text-sm">
              {postContent ? highlightContent(postContent) : "Create amazing content..."}
            </p>
          </div>

          <div className="flex flex-col gap-4">
            <button className="w-10 h-10 bg-gray-800/50 rounded-full flex items-center justify-center text-white">
              <Heart className="w-5 h-5" />
            </button>
            <button className="w-10 h-10 bg-gray-800/50 rounded-full flex items-center justify-center text-white">
              <MessageCircle className="w-5 h-5" />
            </button>
            <button className="w-10 h-10 bg-gray-800/50 rounded-full flex items-center justify-center text-white">
              <Share className="w-5 h-5" />
            </button>
          </div>
        </div>
      </div>
    </div>
  )
}
