import * as React from "react"
import { cn } from "@/Lib/utils"

const Input = React.forwardRef(({ className, type, size = "default", ...props }, ref) => {
  const sizeClasses = {
    xs: "h-7 px-2 text-xs",
    sm: "h-8 px-2.5 text-sm",
    default: "h-10 px-3 text-base",
    lg: "h-12 px-4 text-lg",
    xl: "h-14 px-5 text-xl",
  }

  return (
    <input
      type={type}
      className={cn(
        "flex w-full rounded-lg border bg-background text-foreground",
        "border-border focus:border-border-focus",
        "placeholder:text-foreground-muted",
        "focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary focus-visible:ring-offset-2",
        "disabled:cursor-not-allowed disabled:opacity-50 disabled:bg-background-disabled",
        "transition-all duration-200",
        "dark:bg-surface dark:border-border-secondary",
        "file:border-0 file:bg-transparent file:text-sm file:font-medium",
        sizeClasses[size],
        className,
      )}
      ref={ref}
      {...props}
    />
  )
})
Input.displayName = "Input"

export { Input }
