import SidebarNav from "@/Components/SidebarNav";
import HeaderNav from "@/Components/HeaderNav";
import FlashMessages from "@/Components/FlashMessages";
import { useState } from "react";
import { Menu, X } from "lucide-react";

import { ThemeProvider } from "@/Contexts/ThemeContext";
import { LanguageProvider } from "@/Contexts/LanguageContext";

export default function AppLayout({ children, breadcrumbs }) {
  const [isMobileSidebarOpen, setIsMobileSidebarOpen] = useState(false);

  const toggleMobileSidebar = () => {
    setIsMobileSidebarOpen(!isMobileSidebarOpen);
  };

  return (
    <ThemeProvider>
      <LanguageProvider>
        <div className="flex h-screen bg-gray-50 dark:bg-gray-900 relative">
          {/* Mobile Menu Button */}
          <button
            onClick={toggleMobileSidebar}
            className="lg:hidden fixed top-2 left-2 z-50 p-4 bg-white dark:bg-zinc-900 rounded-lg"
          >
            {isMobileSidebarOpen ? (
              <X className="h-6 w-6 text-gray-700 dark:text-gray-200" />
            ) : (
              <Menu className="h-6 w-6 text-gray-700 dark:text-gray-200" />
            )}
          </button>

          {/* Mobile Sidebar Overlay */}
          {isMobileSidebarOpen && (
            <div
              className="lg:hidden fixed inset-0 bg-black bg-opacity-50 z-40"
              onClick={toggleMobileSidebar}
            />
          )}

          {/* Sidebar - Hidden on mobile by default, slide in when open */}
          <div className={`
            fixed lg:relative
            inset-y-0 left-0
            z-40 lg:z-auto
            transform ${isMobileSidebarOpen ? 'translate-x-0' : '-translate-x-full'}
            lg:translate-x-0
            transition-transform duration-300 ease-in-out
          `}>
            <SidebarNav onMobileClose={() => setIsMobileSidebarOpen(false)} />
          </div>

          <div className="flex flex-col flex-1 w-full lg:w-auto overflow-hidden">
            <HeaderNav breadcrumbs={breadcrumbs} />
            <FlashMessages />
            <div className="flex-1 overflow-auto min-h-0 dark:bg-black pt-4">
              {children}
            </div>
          </div>
        </div>
      </LanguageProvider>
    </ThemeProvider>
  );
}