"use client"
import { router } from "@inertiajs/react"
import { route } from "ziggy-js"
import { Button } from "@/Components/UI/Button"
import AuthLayout from "@/Layouts/AuthLayout"
import { Check } from "lucide-react"
import useTranslate from "@/hooks/useTranslate";

export default function PasswordResetSuccess() {
  const handleLoginRedirect = () => {
    const url = route("auth.login")
    router.get(url)
  }

  const t =  useTranslate()

  return (
    <AuthLayout>
      <div className="flex flex-col items-center justify-center text-center">
        {/* Gradient Checkmark Icon */}
        <div className="relative flex items-center justify-center h-24 w-24 rounded-full bg-gradient-to-br from-blue-500 to-teal-400 mb-6 shadow-md">
          <div className="flex items-center justify-center  h-[3.2rem] w-[3.2rem] rounded-full bg-white">
            <Check className="h-7 w-7 text-blue-500" />
          </div>
        </div>
        <h1 className="text-2xl font-bold mb-4 text-gray-800 dark:text-gray-300">{t("Password Successfully Reset")}</h1>
        <p className="text-gray-600 dark:text-gray-200 mb-8">{t("Proceed to login with your new password")}</p>
        <Button
          onClick={handleLoginRedirect}
          className="w-full py-3 rounded-md font-semibold text-white bg-gradient-to-r from-blue-500 to-teal-400 hover:from-blue-600 hover:to-teal-500 focus:outline-none focus:ring-4 focus:ring-blue-300 transition duration-200"
        >
          {t("Login now")}
        </Button>
      </div>
    </AuthLayout>
  )
}
