<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    @viteReactRefresh
    @vite(['resources/js/app.jsx'])
    <title>{{ env('APP_INSTALL', false) ? (site_settings('site_name') ?? 'Postuno') : 'Postuno Installation' }}</title>
    <style>
        :root {
            @if(env('APP_INSTALL', false))
                --primary-color: {{ site_settings('primary_color') ?? '#667eea' }};
                --secondary-color: {{ site_settings('secondary_color') ?? '#764ba2' }};
                --primary-color-text: {{ site_settings('primary_color_text') ?? '#ffffff' }};
                --secondary-color-text: {{ site_settings('secondary_color_text') ?? '#ffffff' }};
                --body-text-primary: {{ site_settings('body_text_primary') ?? '#1a202c' }};
                --body-text-secondary: {{ site_settings('body_text_secondary') ?? '#718096' }};
            @else
                --primary-color: #667eea;
                --secondary-color: #764ba2;
                --primary-color-text: #ffffff;
                --secondary-color-text: #ffffff;
                --body-text-primary: #1a202c;
                --body-text-secondary: #718096;
            @endif

            /* Dynamic color variations */
            --primary-color-light: color-mix(in srgb, var(--primary-color) 80%, white 20%);
            --primary-color-dark: color-mix(in srgb, var(--primary-color) 80%, black 20%);
            --secondary-color-light: color-mix(in srgb, var(--secondary-color) 80%, white 20%);
            --secondary-color-dark: color-mix(in srgb, var(--secondary-color) 80%, black 20%);

            /* Gradients */
            --button-gradient: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            --button-gradient-hover: linear-gradient(135deg, var(--secondary-color), var(--primary-color));
            --gradient-primary: linear-gradient(135deg, var(--primary-color), var(--primary-color-dark));
            --gradient-secondary: linear-gradient(135deg, var(--secondary-color), var(--secondary-color-dark));
        }
    </style>

</head>
<body>
    @inertia
    @routes
</body>
</html>
