<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMTP Test Email</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f4f4f4;
        }
        .container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 10px 10px 0 0;
            margin: -30px -30px 20px -30px;
            text-align: center;
        }
        .success-icon {
            font-size: 48px;
            margin-bottom: 10px;
        }
        .message {
            padding: 20px;
            background-color: #f0f9ff;
            border-left: 4px solid #3b82f6;
            margin: 20px 0;
            border-radius: 5px;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e5e7eb;
            text-align: center;
            font-size: 12px;
            color: #6b7280;
        }
        .button {
            display: inline-block;
            padding: 12px 24px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="success-icon">✉️</div>
            <h1>SMTP Configuration Test</h1>
        </div>
        
        <h2>Test Email Successful! ✅</h2>
        
        <div class="message">
            <p><strong>{{ $testMessage }}</strong></p>
        </div>
        
        <p>This email confirms that your SMTP settings are configured correctly and working properly.</p>
        
        <h3>Configuration Details:</h3>
        <ul>
            <li><strong>Test performed at:</strong> {{ $timestamp }}</li>
            <li><strong>Email service:</strong> SMTP</li>
            <li><strong>Status:</strong> <span style="color: #10b981;">✓ Working</span></li>
        </ul>
        
        <p>You can now use these settings to send emails from your application.</p>
        
        <div class="footer">
            <p>This is an automated test email. No action is required.</p>
            <p>Generated on {{ $timestamp }}</p>
        </div>
    </div>
</body>
</html>